#ifndef ADC_H
#define ADC_H

#include <stdint.h>

#include "check.h"

/**
 * \addtogroup ADC ADC (Analog to Digital Converter)
 *
 * \brief Interface to the AD-converter of the ATmega32, which allows to
 *        query the potentiometer and the photosensor of the board
 *
 * @{
 * \file adc.h
 * \version \$Rev: 7715 $
 */

/**
 * \brief Device ids of available periphery connected to ADC channels
 */
typedef enum {
	POTI  = 0, /**< the potentiometer (rotation towards LEDs yields higher numbers) **/
	PHOTO = 1  /**< the photosensor (brighter ambience yields higher numbers)       **/
} __attribute__ ((__packed__)) ADCDEV;

CHECK_ENUM_SIZE(ADCDEV, 1)

/**
 * \brief Perform a 10-bit A/D conversion for a specific channel/device
 *
 * \param dev  id of a device connected to the ADC
 *
 * \retval >=0  10-bit result of the conversion
 * \retval -1  invalid device id
 */
int16_t sb_adc_read(ADCDEV dev);

/** @}*/

#endif

